/*
 * Decompiled with CFR 0.152.
 */
package obj2msh;

import java.io.IOException;
import obj2msh.MSHWriter;
import obj2msh.OBJLoader;
import obj2msh.OBJLoaderException;

public class OBJ2MSH {
    static OBJLoader objLoader;

    public static void main(String[] args) {
        String filename = args[0];
        if (filename == null || filename.isEmpty()) {
            System.err.println("Provide path to .OBJ file as only argument");
            System.exit(-1);
        }
        try {
            objLoader = new OBJLoader(filename);
        }
        catch (IOException e) {
            System.err.println("IOException: make sure path to OBJ file is correct.");
            e.printStackTrace();
        }
        catch (OBJLoaderException e) {
            System.err.println("OBJLoaderException: probably malformed OBJ file was given.");
            e.printStackTrace();
        }
        String mshFilename = filename.replaceFirst("\\..*$", ".msh");
        MSHWriter.setData(objLoader);
        MSHWriter.writeMSH(mshFilename);
    }
}

