/*
 * Decompiled with CFR 0.152.
 */
package obj2msh;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import obj2msh.OBJLoader;

public class MSHWriter {
    static float[] vertices;
    static float[] normals;
    static float[] texcoords;
    static int[] triangles;

    public static void setData(OBJLoader obj) {
        Vector<Vector3f> vs = obj.vertexList;
        vertices = new float[vs.size() * 3];
        int i = 0;
        while (i < vs.size()) {
            Vector3f v = vs.get(i);
            MSHWriter.vertices[3 * i + 0] = v.x;
            MSHWriter.vertices[3 * i + 1] = v.y;
            MSHWriter.vertices[3 * i + 2] = v.z;
            ++i;
        }
        Vector<Vector3f> ns = obj.normalList;
        normals = new float[ns.size() * 3];
        int i2 = 0;
        while (i2 < ns.size()) {
            Vector3f n = ns.get(i2);
            MSHWriter.normals[3 * i2 + 0] = n.x;
            MSHWriter.normals[3 * i2 + 1] = n.y;
            MSHWriter.normals[3 * i2 + 2] = n.z;
            ++i2;
        }
        Vector<Vector2f> ts = obj.texcoordList;
        texcoords = new float[ts.size() * 2];
        int i3 = 0;
        while (i3 < ts.size()) {
            Vector2f t = ts.get(i3);
            MSHWriter.texcoords[2 * i3 + 0] = t.x;
            MSHWriter.texcoords[2 * i3 + 1] = t.y;
            ++i3;
        }
        Vector<int[]> tris = obj.indexList;
        triangles = new int[tris.size() * 3];
        int i4 = 0;
        while (i4 < tris.size()) {
            int[] t = tris.get(i4);
            MSHWriter.triangles[3 * i4 + 0] = t[0];
            MSHWriter.triangles[3 * i4 + 1] = t[1];
            MSHWriter.triangles[3 * i4 + 2] = t[2];
            ++i4;
        }
    }

    public static void writeMSH(String filename) {
        try {
            float val;
            File file = new File(filename);
            FileOutputStream os = new FileOutputStream(file);
            PrintWriter w = new PrintWriter(os);
            int nVerts = vertices.length / 3;
            int nTris = triangles.length / 3;
            w.println(nVerts);
            w.println(nTris);
            w.println("vertices");
            Object[] objectArray = vertices;
            int n = vertices.length;
            int n2 = 0;
            while (n2 < n) {
                val = objectArray[n2];
                w.println(val);
                ++n2;
            }
            if (texcoords.length > 0) {
                w.println("texcoords");
            }
            objectArray = texcoords;
            n = texcoords.length;
            n2 = 0;
            while (n2 < n) {
                val = objectArray[n2];
                w.println(val);
                ++n2;
            }
            w.println("triangles");
            objectArray = triangles;
            n = triangles.length;
            n2 = 0;
            while (n2 < n) {
                float val2 = objectArray[n2];
                w.println((int)val2);
                ++n2;
            }
            w.close();
            os.close();
            System.out.println("Successfully wrote " + filename + " [" + nVerts + " vertices, " + nTris + " triangles]");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

