import javax.swing.Icon;

/**
 * The <code>WildcardPiece</code> extends a regular piece 
 * to handle wildcards
 * @author  James Ezick
 * @version 2.0, 02/11/00
 */

class WildcardPiece extends Piece {

  ///////////////////////////////////////////////
  // INSTANCE
  ///////////////////////////////////////////////

  /**
   * Creates a wildcard piece
   */
  public WildcardPiece() {
    letter=WILDCARD;
  }

  /**
   * Sets letter of this piece (only allowed for wildcards)
   * @exception Exception 
   *   if this letter is not a wildcard
   */
  public void setLetter(char c) {
    letter = (char)('A' + super.getIndex(c));  // ensures bounds
  }

  /**
   * Returns value of this piece
   */
  public int getValue() {
    return getValue(WILDCARD);
  }

  /**
   * Returns image of this piece (or what it represents)
   */
  public Icon getIcon() {
    return getIcon(WILDCARD);
  }

  /**
   * Returns wildcard count/frequency
   */
  public int getCount() {
    return getCount(WILDCARD);
  }

  /**
   * Converts piece information to string
   */
  public String toString() {
    return "("+getLetter()+")";
  }


  ///////////////////////////////////////////////
  // STATIC
  ///////////////////////////////////////////////

  /**
   * Wildchar character constant
   */
  public static final char WILDCARD = '_';

  /**
   * Wildchar value/score
   */
  private static final int VALUE = 0;

  /**
   * Wildchar count/frequency
   */
  private static final int COUNT = 2;

  /** 
   * Letter images
   */
  private static Icon IMAGE;
  
  static {
    try {
      java.io.ObjectInputStream in=
        new java.io.ObjectInputStream(
        new java.util.zip.GZIPInputStream(
        new java.io.FileInputStream("IMAGES.bin")));
      byte pics[][]=(byte[][])in.readObject();
      IMAGE=new javax.swing.ImageIcon(pics[pics.length-1]);
    }
    catch (Exception e) {
      IMAGE = null;
    }
  }

  /**
   * Returns value of wildcard
   */
  public static int getValue(char c) {
    return VALUE;
  }

  /**
   * Returns image of wildcard
   */
  public static Icon getIcon(char c) {
    return c==WILDCARD ? IMAGE : Piece.getIcon(c);
  }

  /**
   * Returns wildcard count/frequency
   */
  public static int getCount(char c) {
    return COUNT;
  }


}
