import java.io.*;
import java.net.*;

/**
 * The <code>JavlleServer</code> receives Board information and broadcasts
 * it to all clients
 * @author  James Ezick
 * @version 2.0, 02/11/00
 */

class JavlleServer {

  /**
   * Default JavlleServer port
   */
  public static final int DEFAULT_PORT = 2002;

  /**
   * Server listening socket
   */
  private ServerSocket ss;

  /**
   * Bind to given port
   */
  public JavlleServer(int port) throws IOException {
    ss=new ServerSocket(port);
  }

  /**
   * Bind to default port
   */
  public JavlleServer() throws IOException {
    this(DEFAULT_PORT);
  }

  /**
   * Create a new board, listen for requests
   * and spawn handler threads
   */
  public void listen() throws IOException {
    Board b=new Board();
    while(true) {
      Socket s=ss.accept();
      (new Thread(new JavlleServerHandler(s, b))).start();
    }
  }
}
