import java.io.*;
import java.net.*;

/**
 * The <code>JavlleClient</code> class sends and receives Board information
 * to/from the server
 * @author  James Ezick
 * @version 2.0, 02/11/00
 */

class JavlleClient {

  /**
   * Client socket and streams
   */
  private Socket s;
  private BufferedReader is;
  private PrintWriter os;

  /**
   * Initialize connections and streams to server
   */
  public JavlleClient(String host, int port) throws IOException {
    s=new Socket(host, port);
    is=new BufferedReader(new InputStreamReader(s.getInputStream()));
    os=new PrintWriter(s.getOutputStream());
  }

  /**
   * Loop infinitely listening for board data
   */
  public void boardListen(Board b) throws IOException {
    while(true) {
      String s=is.readLine();
      if(s==null) break;
      b.fromString(s);
    }
  }

  /**
   * Send board to server
   */
  public void boardSend(Board b) throws IOException {
    os.println(b);
    os.flush();
  }
}
