#include <stdio.h>
#include "DT_data.h"

/*
	Sample code for using DT_data to access vectors in the format used
	by svmlight (http://svmlight.joachims.org/). To compile it run:
	
	  gcc -Wall -o sample sample.c DT_data.c
	
	For it to run you need the adult1.train file present, but without
	it the format is still clear. Please let me know if you find any
	bugs.
	
	Filip Radlinski
	filip@cs.cornell.edu
*/

int main() {

	int DT_file, i;
	struct DT_vector *vec;
	
	/* You must call init first! */
	DT_init();

	/* Open the file, returns an integer. In the case where the
		 labels are in the same file as the vectors (as in CS678)
		 the second parameter of DT_open is always NULL */
	DT_file = DT_open("adult1.train", NULL);

	/* DT_next returns a pointer to the next vector. You can
		 assign it to an array to save all the vectors. DT_next
		 returns NULL when it runs out of examples. */
	while((vec = DT_next(DT_file)) != NULL) {

		/* The vector tells you its size and label. The label is
			 a string! */
		printf("Vector with %i non-zero dimensions. Label is '%s'\n",
					 vec->size, vec->label);

		/* The dimensions and values arrays hold the actual vector
			 data in the obvious way. DT_print(vec) would do the same
			 thing, except print more decimal points. */
		for(i=0; i<vec->size; i++)
			printf("%i:%.1f ", vec->dimensions[i], vec->values[i]);
		printf("\n");
		
		/* This frees the vector data structure */
		DT_free(vec);
	}
	
	/* Its good form to close files. You can currently have a maximum
		 of 5 open data files. */
	DT_close(DT_file);

	return 0;
}
