/*
	Header file for DT_data.c, for accessing vectors in svmlight format
	(http://svmlight.joachims.org/). This code has a GPL license. Please
	let me know if you find any bugs.
	
	Filip Radlinski, 11 Feb 2003
	filip@cs.cornell.edu
*/


/* Maximum of 5 training or test sets open at any one time */
#define MAX_FILES 5

/* Maximum length of any line in the data files. This should be made dynamic */
#define MAX_VEC_STR_LEN 20000

/* This defines the vector structure */
struct DT_vector {
		int size;
		int *dimensions;
		double *values;
		char *label;
};

/* Initialize data variables */
void DT_init();

/* Open the docfile and labelfile, labelfile NULL if label included
	 in docfile */
int DT_open(char *docfile, char *labelfile);

/* Close the docfile and labelfile for this docno */
void DT_close(int docno);

/* Rewind the docfile and labelfile for this docno. Return 1 on success,
	 and 0 on failure. */
int DT_rewind(int docno);

/* Get the next document vector and label */
struct DT_vector *DT_next(int docno);

/* Get the (n+1)th record in the file */
struct DT_vector *DT_find(int docno, int n);

/* Get max value in vector */
int DT_max(struct DT_vector *vec);

/* Print out a vector (no newline) */
void DT_print(struct DT_vector *vec);

void DT_free(struct DT_vector *vec);

