#pragma once

#include <string>
#include <vector>

class Sparm
{
private:
	std::string m_inputFilename; 
	std::string m_modelFilename; 
	int m_maxMonth;
	size_t m_sizePsi;          // feature dimension [by stacking different weight vectors for each month]
	size_t m_original_sizePsi; // original feature dimension
	double m_C1; 
	double m_C2; 
	std::string m_lossType; 
	bool m_printProb;          // print probabilities during prediction (for plotting survival cdf)
	double m_threshold;        // threshold for classification
	int m_bundleSize; 
	int m_trainUncensored; 
	std::string m_initialWeightFile; 
	std::vector<double> m_quantTime; 
public:
	Sparm(void);
	~Sparm(void);

	void ReadParam(int argc, char ** argv); 

	std::string GetInputFile() const
	{
		return m_inputFilename; 
	}
	std::string GetModelFile() const
	{
		return m_modelFilename; 
	}
	int GetMaxMonth() const
	{
		return m_maxMonth; 
	}
	size_t GetSizePsi() const
	{
		return m_sizePsi;
	}
	size_t GetOriginalSizePsi() const
	{
		return m_original_sizePsi; 
	}
	void SetSizePsi(size_t n)
	{
		m_original_sizePsi = n; 
		m_sizePsi = m_maxMonth*n + m_maxMonth; 
	}
	double GetC1() const
	{
		return m_C1;
	}
	double GetC2() const
	{
		return m_C2;
	}
	std::string GetLossType() const
	{
		return m_lossType; 
	}
	bool GetPrintProb() const 
	{
		return m_printProb; 
	}
	double GetThreshold() const
	{
		return m_threshold;
	}
	int GetBundleSize() const
	{
		return m_bundleSize;
	}
	int GetTrainUncensored() const
	{
		return m_trainUncensored;
	}
	std::string GetInitialWeightFile() const
	{
		return m_initialWeightFile; 
	}
	std::vector<double> &GetQuantTime()
	{
		return m_quantTime; 
	}
	void ReadQuantTime(std::string filename); 
};

